<?php
// bot.php
require_once 'config.php';

$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (isset($update['message'])) {
    $chat_id = $update['message']['chat']['id'];
    $text = $update['message']['text'];

    if ($text == '/start') {
        // একটি ইউনিক ইমেইল তৈরি করা হচ্ছে (chat_id ব্যবহার করে)
        $email_alias = $chat_id . '@' . $domain;

        // ডাটাবেসে চেক বা ইনসার্ট করা
        $stmt = $conn->prepare("INSERT IGNORE INTO telegram_users (chat_id, email_alias) VALUES (?, ?)");
        $stmt->bind_param("ss", $chat_id, $email_alias);
        
        if ($stmt->execute()) {
            $msg = "স্বাগতম! আপনার ব্যক্তিগত ইমেইল হলো:\n\n`" . $email_alias . "`\n\nএই ইমেইলে কোনো মেইল আসলে তা আপনি এখানে দেখতে পাবেন।";
        } else {
            $msg = "আপনার ইমেইল ইতিমধ্যে তৈরি করা আছে: " . $email_alias;
        }
        
        sendTelegramMessage($chat_id, $msg, $bot_token);
    }
}
?>