#!/usr/local/bin/php -q
<?php
// pipe.php
require_once '/home/skprotik/new.skprotik.com/gem/config.php'; 
// দ্রষ্টব্য: config.php এর ফুল পাথ (Full Path) দিতে হবে কারণ এটি কমান্ড লাইন থেকে রান হবে।

// ইমেইল পড়া (STDIN থেকে)
$fd = fopen("php://stdin", "r");
$email_content = "";
while (!feof($fd)) {
    $email_content .= fread($fd, 1024);
}
fclose($fd);

// সাবজেক্ট এবং প্রেরক বের করার জন্য সাধারণ পার্সিং
// (প্রোডাকশনে "php-mime-mail-parser" লাইব্রেরি ব্যবহার করা ভালো, তবে এখানে সাধারণ লজিক দেওয়া হলো)

function extractHeader($header_name, $content) {
    preg_match("/^$header_name: (.*)$/m", $content, $matches);
    return isset($matches[1]) ? trim($matches[1]) : 'Unknown';
}

$subject = extractHeader('Subject', $email_content);
$from = extractHeader('From', $email_content);
$to_header = extractHeader('To', $email_content);

// প্রাপক (To) ইমেইল থেকে ইমেইল এড্রেসটি ক্লিন করা
preg_match("/[a-z0-9_\-\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i", $to_header, $clean_to);
$recipient_email = isset($clean_to[0]) ? $clean_to[0] : '';

// ডাটাবেসে চেক করা এই ইমেইলটি কার
if ($recipient_email) {
    $stmt = $conn->prepare("SELECT chat_id FROM telegram_users WHERE email_alias = ?");
    $stmt->bind_param("s", $recipient_email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $chat_id = $row['chat_id'];
        
        // বডি বের করা (খুব সাধারণ পদ্ধতি)
        $body_parts = explode("\n\n", $email_content, 2);
        $body = isset($body_parts[1]) ? substr($body_parts[1], 0, 3000) : "No text content found."; // ৩০০০ ক্যারেক্টার লিমিট
        
        // টেলিগ্রামে পাঠানো
        $message = "📧 **নতুন ইমেইল এসেছে!**\n\n";
        $message .= "From: $from\n";
        $message .= "Subject: $subject\n";
        $message .= "To: $recipient_email\n\n";
        $message .= "----------------------\n";
        $message .= $body;

        sendTelegramMessage($chat_id, $message, $bot_token);
    }
}
?>